/********************************************
; File: Locator.h
;
;
; Copyright Apple Computer, Inc.1986-90
; All Rights Reserved
;
********************************************/
#ifndef __TYPES__
#include <TYPES.h>
#endif

#ifndef __LOCATOR__
#define __LOCATOR__


/* Error Codes */
#define toolNotFoundErr 0x0001
#define funcNotFoundErr 0x0002
#define sysStrtMtErr 0x0100  /* can't mount system startup volume */
#define tlBadRecFlag 0x0103  /* StartStop record invalid */
#define tlCantLoad 0x0104  /* A tool cannot be loaded */
#define toolVersionErr 0x0110
#define messNotFoundErr 0x0111
#define messageOvfl 0x0112  /* No message numbers available */
#define nameTooLong 0x0113  /* Message name too long */

/* MessageCenter Codes */
#define fileInfoType 0x0001  /* Message type parameter */
#define addMessage 0x0001  /* action parameter */
#define getMessage 0x0002  /* action parameter */
#define deleteMessage 0x0003  /* action parameter */

/* TLMountVolume Codes */
#define mvReturn 0x0001  /* like ok for dialogs */
#define mvEscape 0x0002  /* like cancel for dialogs */

/* Tool Set Spec Codes */
#define sysTool 0x0000
#define userTool 0x8000
#ifndef theToolsLength  /* ToolTable - default number of ToolSpecs */
#define theToolsLength 0x0010
#endif
struct MessageRec {
   struct MessageRec **messageNext; /*   */
   Word messageType; /*   */
   Word messageData; /*   */
   Str255 fileNames[1]; /*   */
} ;
typedef struct MessageRec MessageRec, *MessageRecPtr, **MessageRecHndl;
struct ToolSpec {
   Word toolNumber; /*   */
   Word minVersion; /*   */
} ;
typedef struct ToolSpec ToolSpec;
struct ToolTable {
   Word toolCount; /*   */
   ToolSpec theTools[theToolsLength]; /*   */
} ;
typedef struct ToolTable ToolTable, *ToolTablePtr;
struct StartStopRecord {
   Word flags;
   Word videoMode;
   Word resFileID;
   Handle dPageHandle;
   Word numTools;
   ToolSpec theTools[theToolsLength]; /*   */
} ;
typedef struct StartStopRecord StartStopRecord, *StartStopRecordPtr;
typedef Long ResponseRecord;
extern pascal Pointer GetFuncPtr() inline(0x0B01,dispatcher);
extern pascal Pointer GetTSPtr() inline(0x0901,dispatcher);
extern pascal Pointer GetWAP() inline(0x0C01,dispatcher);
extern pascal void LoadOneTool() inline(0x0F01,dispatcher);
extern pascal void LoadTools() inline(0x0E01,dispatcher);
extern pascal ResponseRecord MessageByName() inline(0x1701,dispatcher);
extern pascal void MessageCenter() inline(0x1501,dispatcher);
extern pascal void RestoreTextState() inline(0x1401,dispatcher);
extern pascal Handle SaveTextState();
extern pascal void SetDefaultTPT() inline(0x1601,dispatcher);
extern pascal void SetTSPtr() inline(0x0A01,dispatcher);
extern pascal void SetWAP() inline(0x0D01,dispatcher);
extern pascal void ShutDownTools() inline(0x1901,dispatcher);
extern pascal Ref StartUpTools() inline(0x1801,dispatcher);
extern pascal void TLBootInit() inline(0x0101,dispatcher);
extern pascal Word TLMountVolume() inline(0x1101,dispatcher);
extern pascal void TLReset() inline(0x0501,dispatcher);
extern pascal void TLShutDown() inline(0x0301,dispatcher);
extern pascal void TLStartUp() inline(0x0201,dispatcher);
extern pascal Boolean TLStatus() inline(0x0601,dispatcher);
extern pascal Word TLTextMountVolume() inline(0x1201,dispatcher);
extern pascal Word TLVersion() inline(0x0401,dispatcher);
extern pascal void UnloadOneTool() inline(0x1001,dispatcher);
#endif
